unit fROR_HEPCPatientEdit;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 18 $  $Modtime: 10/27/05 1:27p $
*       Site:           Hines OIFO
*       Developers:                    
*       Description:    HepC Patient Record Editor
*
*	Notes:
*
================================================================================
*	$Archive: /CCR v1.0/Current/fROR_HEPCPatientEdit.pas $
*
* $History: fROR_HEPCPatientEdit.pas $
 * 
 * *****************  Version 18  *****************
 * User: Vhaishgavris Date: 10/27/05   Time: 3:54p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 17  *****************
 * User: Vhaishgavris Date: 9/07/05    Time: 3:45p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 16  *****************
 * User: Vhaishgavris Date: 8/20/05    Time: 2:46p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 15  *****************
 * User: Vhaishgavris Date: 8/19/05    Time: 3:51p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 14  *****************
 * User: Vhaishgavris Date: 8/18/05    Time: 4:56p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 13  *****************
 * User: Vhaishgavris Date: 8/05/05    Time: 3:54p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 12  *****************
 * User: Vhaishgavris Date: 6/06/05    Time: 3:40p
 * Updated in $/CCR v1.0/Current
 * 
*
================================================================================
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fROR_PatientEdit, ImgList, ActnList, ComCtrls, StdCtrls, Buttons,
  ExtCtrls, uROR_Common, uROR_HEPCPatientData, Grids, uROR_Errors,
  uROR_ListView, uROR_CustomListView, uROR_GridView, BaseGrid, AdvGrid,
  AdvCGrid, uROR_AdvColGrid, VA508AccessibilityManager;

type
  TFormHEPCPatientEdit = class(TFormPatientEdit)

  private
    { Private declarations }

  protected
    function  getPatientData: THEPCPatientData;

  public
    procedure AfterConstruction; override;
    property PatientData: THEPCPatientData read getPatientData;
  end;

implementation
{$R *.DFM}

uses
  uROR_CommonUtils, uROR_Utilities, uROR_Classes, uROR_PatientDataLists;

procedure TFormHEPCPatientEdit.AfterConstruction;
var
  i: integer;
begin
  inherited;
  if CCRScreenReaderActive then
  begin
    for i := 0 to ComponentCount - 1 do
      if (Components[i] is TStaticText) then
      begin
        with TStaticText(Components[i]) do
          TabStop := true;
      end;
  end;
end;

function TFormHEPCPatientEdit.getPatientData: THEPCPatientData;
begin
  Result := THEPCPatientData(inherited getPatientData);
end;

end.
